package gov.va.med.mhv.common.api.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum UserTypeEnum {
	PREMIUM ("Premium"),
	ADVANCED ("Advanced"),
	ADVANCED_VAPATIENT ("Advanced", "VA Patient"),
	ADVANCED_NONVAPATIENT ("Advanced", "Non-VA Patient"),
	BASIC ("Basic");
	
	private String role;
	private String subRole;
	
	private UserTypeEnum() {
	}
	
	public String getRole() {
		return role;
	}
	
	public String getSubRole() {
		return subRole;
	}
	
	private UserTypeEnum(String role){
		this.role = role;
	}
	
	private UserTypeEnum(String role, String subRole){
		this.role = role;
		this.subRole = subRole;
	}
	
	public static List<UserTypeEnum> toList(){
		return Arrays.asList(UserTypeEnum.values());
	}
	
	public static UserTypeEnum valueOfByRole(String role) {
		for( UserTypeEnum e: UserTypeEnum.values()) {
			if(e.getRole().equals(role)) {
				return e;
			}
		}
		return null;
	}
	
	public static List<String> toRoleList(){
		List<String> roleList = new ArrayList<String>();
		for(UserTypeEnum ft : Arrays.asList(UserTypeEnum.values())) {
			roleList.add(ft.getRole());
		}
		return roleList;
	}
	
	static public boolean isPremium(UserTypeEnum userType) {
		return userType == PREMIUM;
	}
	
	static public boolean isAdvanced(UserTypeEnum userType) {
		return userType == ADVANCED || userType == ADVANCED_NONVAPATIENT || userType == ADVANCED_VAPATIENT;
	}
	
	static public boolean isBasic(UserTypeEnum userType) {
		return userType == BASIC;
	}
	
//	public static void main(String arv[]) {
//		UserTypeEnum e = UserTypeEnum.ADVANCED;
//		if( UserTypeEnum.isAdvanced(e) ) {
//			System.out.println("Advanced");
//		}
//		e = UserTypeEnum.ADVANCED_VAPATIENT;
//		if( UserTypeEnum.isAdvanced(e) ) {
//			System.out.println("Advanced VA Patient / " + e.getSubRole());
//		}
//		e = UserTypeEnum.ADVANCED_NONVAPATIENT;
//		if( UserTypeEnum.isAdvanced(e) ) {
//			System.out.println("Advanced Non VA Patient / " + e.getSubRole());
//		}
//	}
}
